# Default Inbound CRM SOP (Template)

## 1) Business Context

[Your Business Name] is an education business focused on AI Automation and Agentic Systems.
Core outcomes:

- teach practical AI automation and agent workflows
- review tools/features/use-cases
- create audience value first

Primary revenue source today:

- video sponsorships and strategic partnerships

## 2) Classification Policy (Source of Truth)

Use exactly one label per inbound email:

1. `sales` (Lead)
2. `receipt`
3. `support`
4. `ignore`

### 2.1 `sales` (Lead) Definition

Classify as `sales` when a human sender reaches out for a business conversation, including:

- consulting/advisory opportunities
- expert-network requests (paid consultation/interview)
- sponsorship/partnership/affiliate/collaboration proposals
- campaign briefs, deliverables, timeline, budget discussions
- follow-up outreach for business opportunity

These are `sales` even if wording is informal or indirect.

### 2.2 `ignore` Definition

Classify as `ignore` when inbound is not a real business opportunity:

- newsletters, digests, updates, alerts
- job alerts/recruiting blasts/general hiring spam
- system/vendor notifications and automated product emails
- social platform summaries

### 2.3 `receipt` Definition

- invoices, payment confirmations, subscription charges, tax receipts

### 2.4 `support` Definition

- direct help/problem request about [Your Business Name] services/content operations

## 3) Hard Inclusion Examples (Must classify as `sales`)

1. Expert network outreach asking for paid consultation call.
2. Creator partnership/affiliate inquiry from SaaS/tool company.
3. Sponsorship inquiry asking for quick call, brief, or pricing.

## 4) Hard Exclusion Examples (Must classify as `ignore`)

1. LinkedIn job update/newsletter/notification.
2. Generic platform digest with unsubscribe links and no business ask.
3. Automated vendor/system account updates.

## 5) Lead Qualification Checklist

Before drafting, confirm:

1. Sender appears human (not no-reply automation).
2. There is explicit or implied commercial intent.
3. Message asks for next step (call, brief, proposal, deliverables, budget, timeline).

## 6) Lead Handling Workflow

1. Research sender/company website and offering.
2. Assess fit with [Your Business Name] audience and values.
3. If fit is unclear, ask clarifying questions (objective, deliverables, timeline, budget).
4. Create draft response for review.
5. Log lead/activity to database.

## 7) Response Style Rules

- friendly, concise, professional
- no hype or fluff
- ask only the minimum questions needed to move forward
- include clear next step CTA

## 8) Data + Labeling Rules

For each `sales` lead:

1. apply Gmail label `CRM/Lead`
2. persist activity in CRM tables
3. produce suggested response draft for approval

